package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Objects;
import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class DataRetentionGenerationConfig {

    @VisibleForTesting
    static final Optional<DataRetentionLimits> EMPTY_LIMITS = Optional.empty();

    private final boolean enabled;
    private final DataRetentionLimits defaultLimits;

    DataRetentionGenerationConfig(boolean enabled,
                                         DataRetentionLimits defaultLimits) {
        this.enabled = enabled;
        this.defaultLimits = defaultLimits;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DataRetentionGenerationConfig that = (DataRetentionGenerationConfig) o;
        return enabled == that.enabled
                && Objects.equals(defaultLimits, that.defaultLimits);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                enabled,
                defaultLimits
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("enabled", enabled)
                .add("defaultLimits", defaultLimits)
                .toString();
    }

    public Optional<DataRetentionLimits> getDataRetentionLimits() {
        if (!enabled) {
            return Optional.empty();
        }

        return Optional.of(defaultLimits);
    }

    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this);
    }

    @VisibleForTesting
    static class Builder {

        private boolean enabled;
        private DataRetentionLimits defaultLimits;

        Builder(DataRetentionGenerationConfig config) {
            this.enabled = config.enabled;
            this.defaultLimits = config.defaultLimits;
        }

        DataRetentionGenerationConfig build() {
            return new DataRetentionGenerationConfig(
                    enabled,
                    defaultLimits
            );
        }

        @VisibleForTesting
        Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @VisibleForTesting
        Builder withDefaultLimits(DataRetentionLimits defaultLimits) {
            this.defaultLimits = defaultLimits;
            return this;
        }
    }
}
