package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;

import ru.yandex.infra.stage.ConfigUtils;

public class DataRetentionGenerationConfigParser {

    @VisibleForTesting
    static final String DATA_RETENTION_ENABLED_CONFIG_PATH = "enabled";

    @VisibleForTesting
    static final String DATA_RETENTION_DEFAULT_LIMITS_CONFIG_PATH = "default";

    @VisibleForTesting
    static final String DATA_RETENTION_LIMITS_AGE_CONFIG_PATH = "age";

    @VisibleForTesting
    static final String DATA_RETENTION_LIMITS_SIZE_CONFIG_PATH = "size";

    private static DataRetentionLimits parseDataRetentionLimits(Config config) {
        var builder = DataRetentionLimits.builder();

        var ageLimit = ConfigUtils.getOptional(
                config,
                DATA_RETENTION_LIMITS_AGE_CONFIG_PATH,
                ConfigUtils.STRING_FROM_CONFIG
        );

        ageLimit.ifPresent(builder::withAgeLimit);

        var sizeLimit = ConfigUtils.getOptional(
                config,
                DATA_RETENTION_LIMITS_SIZE_CONFIG_PATH,
                ConfigUtils.STRING_FROM_CONFIG
        );

        sizeLimit.ifPresent(builder::withSizeLimit);

        return builder.build();
    }

    static DataRetentionGenerationConfig parseConfig(Config config) {
        var enabled = config.getBoolean(DATA_RETENTION_ENABLED_CONFIG_PATH);

        var defaultLimits = parseDataRetentionLimits(
                config.getConfig(DATA_RETENTION_DEFAULT_LIMITS_CONFIG_PATH)
        );

        return new DataRetentionGenerationConfig(
                enabled,
                defaultLimits
        );
    }
}
