package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class DataRetentionLimits {

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private final String ageLimit;

    @Nullable
    private final String sizeLimit;

    @VisibleForTesting
    DataRetentionLimits(@Nullable String ageLimit,
                        @Nullable String sizeLimit) {
        this.ageLimit = ageLimit;
        this.sizeLimit = sizeLimit;
    }

    public Optional<String> getAgeLimit() {
        return Optional.ofNullable(ageLimit);
    }

    public Optional<String> getSizeLimit() {
        return Optional.ofNullable(sizeLimit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DataRetentionLimits that = (DataRetentionLimits) o;
        return Objects.equals(ageLimit, that.ageLimit)
                && Objects.equals(sizeLimit, that.sizeLimit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                ageLimit,
                sizeLimit
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("ageLimit", ageLimit)
                .add("sizeLimit", sizeLimit)
                .toString();
    }

    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {

        @Nullable private String ageLimit;
        @Nullable private String sizeLimit;

        private Builder(@Nullable String ageLimit,
                        @Nullable String sizeLimit) {
            this.ageLimit = ageLimit;
            this.sizeLimit = sizeLimit;
        }

        public Builder() {
            this(
                    null,
                    null
            );
        }

        Builder(DataRetentionLimits dataRetentionLimits) {
            this(
                    dataRetentionLimits.ageLimit,
                    dataRetentionLimits.sizeLimit
            );
        }

        public DataRetentionLimits build() {
            return new DataRetentionLimits(
                    ageLimit,
                    sizeLimit
            );
        }

        Builder withoutAgeLimit() {
            return withAgeLimit(null);
        }

        Builder withAgeLimit(@Nullable String ageLimit) {
            this.ageLimit = ageLimit;
            return this;
        }

        Builder withoutSizeLimit() {
            return withSizeLimit(null);
        }

        Builder withSizeLimit(@Nullable String sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }
    }
}
