package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;

import ru.yandex.infra.stage.ConfigUtils;
import ru.yandex.misc.lang.StringUtils;

public class ErrorBoosterIsEnabledPredicateParser {

    @VisibleForTesting
    static final String ERROR_BOOSTER_FIRST_AFFECTED_UNIFIED_AGENT_VERSION_CONFIG_PATH =
            "first_affected_unified_agent_version";

    @VisibleForTesting
    static final String ERROR_BOOSTER_ENABLED_IN_RELEASE_FLAG_NAME_CONFIG_PATH =
            "enabled_in_release_flag_name";

    static ErrorBoosterIsEnabledPredicate parseConfig(Config config) {
        var firstAffectedUnifiedAgentVersion = config.getLong(
                ERROR_BOOSTER_FIRST_AFFECTED_UNIFIED_AGENT_VERSION_CONFIG_PATH
        );

        var enabledInReleaseFlagName = ConfigUtils.getOptional(
                config, ERROR_BOOSTER_ENABLED_IN_RELEASE_FLAG_NAME_CONFIG_PATH, ConfigUtils.STRING_FROM_CONFIG
        ).filter(StringUtils::isNotBlank);

        return new ErrorBoosterIsEnabledPredicateImpl(
                firstAffectedUnifiedAgentVersion,
                enabledInReleaseFlagName
        );
    }
}
