package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

class ThrottlingLimits {

    private final String maxRate;
    private final int maxMessagesRate;

    @VisibleForTesting
    ThrottlingLimits(String maxRate, int maxMessagesRate) {
        this.maxRate = maxRate;
        this.maxMessagesRate = maxMessagesRate;
    }

    String getMaxRate() {
        return maxRate;
    }

    int getMaxMessagesRate() {
        return maxMessagesRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ThrottlingLimits that = (ThrottlingLimits) o;
        return maxMessagesRate == that.maxMessagesRate && Objects.equal(maxRate, that.maxRate);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(maxRate, maxMessagesRate);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("maxRate", maxRate)
                .add("maxMessagesRate", maxMessagesRate)
                .toString();
    }
}
