package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;

import ru.yandex.infra.stage.podspecs.SandboxResourceMeta;
import ru.yandex.infra.stage.podspecs.SandboxResourceMetaAttributesUtils;

import static ru.yandex.infra.stage.podspecs.SandboxResourceMetaAttributesUtils.FLAG_CALCULATOR;

final class ThrottlingPolicyCalculatorImpl implements ThrottlingPolicyCalculator {

    static final ThrottlingPolicyCalculatorImpl INSTANCE =
            new ThrottlingPolicyCalculatorImpl();

    private final SandboxResourceMetaAttributesUtils.FlagCalculator flagCalculator;

    private ThrottlingPolicyCalculatorImpl() {
        this(FLAG_CALCULATOR);
    }

    private ThrottlingPolicyCalculatorImpl(SandboxResourceMetaAttributesUtils.FlagCalculator flagCalculator) {
        this.flagCalculator = flagCalculator;
    }

    @VisibleForTesting
    static final String USE_YD_THROTTLING_ATTRIBUTE_KEY = "use_yd_throttling";

    @VisibleForTesting
    static final String YD_THROTTLING_BEFORE_COMPRESSION_ATTRIBUTE_KEY = "throttling_before_compression";

    @Override
    public ThrottlingPolicy calculate(Optional<SandboxResourceMeta> unifiedAgentSandboxMeta) {
        boolean useThrottling = flagCalculator.getFlagValue(
                unifiedAgentSandboxMeta, USE_YD_THROTTLING_ATTRIBUTE_KEY
        );

        boolean throttlingBeforeCompression = flagCalculator.getFlagValue(
                unifiedAgentSandboxMeta, YD_THROTTLING_BEFORE_COMPRESSION_ATTRIBUTE_KEY
        );

        if (useThrottling) {
            return throttlingBeforeCompression
                    ? ThrottlingPolicy.THROTTLING_BEFORE_COMPRESSION
                    : ThrottlingPolicy.THROTTLING_AFTER_COMPRESSION;
        }

        return ThrottlingPolicy.DISABLED;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ThrottlingPolicyCalculatorImpl that = (ThrottlingPolicyCalculatorImpl) o;
        return Objects.equal(flagCalculator, that.flagCalculator);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(flagCalculator);
    }

    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this);
    }

    @VisibleForTesting
    static class Builder {

        private SandboxResourceMetaAttributesUtils.FlagCalculator flagCalculator;

        Builder(ThrottlingPolicyCalculatorImpl throttlingPolicyCalculator) {
            this.flagCalculator = throttlingPolicyCalculator.flagCalculator;
        }

        Builder withFlagCalculator(SandboxResourceMetaAttributesUtils.FlagCalculator flagCalculator) {
            this.flagCalculator = flagCalculator;
            return this;
        }

        ThrottlingPolicyCalculatorImpl build() {
            return new ThrottlingPolicyCalculatorImpl(
                    flagCalculator
            );
        }
    }
}
