package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;

public class UnifiedAgentConfigFactoryParser {

    @VisibleForTesting
    static final String THROTTLING_CONFIG_PATH = "throttling";

    @VisibleForTesting
    static final String ERROR_BOOSTER_CONFIG_PATH = "error_booster";

    @VisibleForTesting
    static final String VERSION_CALCULATOR_CONFIG_PATH = "version_calculator";

    @VisibleForTesting
    static final String DATA_RETENTION_CONFIG_PATH = "data_retention";

    @VisibleForTesting
    public static UnifiedAgentConfigFactory parseConfig(Config config) {
        var throttlingConfig = ThrottlingGenerationConfigParser.parseConfig(
                config.getConfig(THROTTLING_CONFIG_PATH)
        );

        var errorBoosterIsEnabledPredicate = ErrorBoosterIsEnabledPredicateParser.parseConfig(
                config.getConfig(ERROR_BOOSTER_CONFIG_PATH)
        );

        var versionCalculator = VersionCalculatorParser.parseConfig(
                config.getConfig(VERSION_CALCULATOR_CONFIG_PATH)
        );

        var dataRetentionConfig = DataRetentionGenerationConfigParser.parseConfig(
                config.getConfig(DATA_RETENTION_CONFIG_PATH)
        );

        return new UnifiedAgentConfigFactory(
                throttlingConfig,
                errorBoosterIsEnabledPredicate,
                versionCalculator,
                dataRetentionConfig
        );
    }
}
