package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Map;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;
import one.util.streamex.EntryStream;

import ru.yandex.infra.stage.ConfigUtils;

public class VersionCalculatorParser {

    @VisibleForTesting
    static final String VERSION_TO_FIRST_AFFECTED_UNIFIED_AGENT_VERSION_CONFIG_PATH =
            "version_to_first_affected_unified_agent_version";

    @VisibleForTesting
    static final String DEFAULT_VERSION_CONFIG_PATH = "default_version";

    private static UnifiedAgentConfigVersion stringToVersion(String versionKey) {
        return UnifiedAgentConfigVersion.valueOf(versionKey.toUpperCase());
    }

    private static Map<UnifiedAgentConfigVersion, Long> parseVersionToFirstAffectedUnifiedAgentVersion(Config config) {
        var versionStringToFirstAffectedUnifiedAgentVersion = ConfigUtils.extractMap(
                config,
                Config::getLong
        );

        return EntryStream.of(versionStringToFirstAffectedUnifiedAgentVersion)
                .mapKeys(VersionCalculatorParser::stringToVersion)
                .toMap();
    }

    static VersionCalculator parseConfig(Config config) {
        var versionToFirstAffectedUnifiedAgentVersion = parseVersionToFirstAffectedUnifiedAgentVersion(
                config.getConfig(VERSION_TO_FIRST_AFFECTED_UNIFIED_AGENT_VERSION_CONFIG_PATH)
        );

        var defaultVersion = stringToVersion(
                config.getString(DEFAULT_VERSION_CONFIG_PATH)
        );

        return new VersionCalculatorImpl(
                versionToFirstAffectedUnifiedAgentVersion,
                defaultVersion
        );
    }
}
