package ru.yandex.infra.stage.podspecs.patcher.logbroker.unified_agent_config;

import java.util.Optional;
import java.util.Set;

import ru.yandex.infra.stage.dto.LogbrokerTopicDescription;

public final class VersionFactoryImpl implements VersionFactory {

    static final VersionFactoryImpl INSTANCE = new VersionFactoryImpl();

    private VersionFactoryImpl() { }

    @Override
    public UnifiedAgentConfig build(
            UnifiedAgentConfigVersion version,
            long buildTaskId,
            String staticSecret,
            String stageId,
            String deployUnitId,
            ThrottlingPolicy throttlingPolicy,
            ThrottlingLimits throttlingLimits,
            Optional<DataRetentionLimits> dataRetentionLimits,
            Set<String> clusters,
            LogbrokerTopicDescription topicDescription) {

        switch (version) {
            case V2:
                return new UnifiedAgentConfigV2(
                        buildTaskId,
                        staticSecret,
                        stageId,
                        deployUnitId,
                        throttlingLimits,
                        dataRetentionLimits,
                        clusters,
                        topicDescription
                );
            case V1:
            default:
                return new UnifiedAgentConfigV1(
                        buildTaskId,
                        staticSecret,
                        stageId,
                        deployUnitId,
                        throttlingPolicy,
                        throttlingLimits,
                        clusters,
                        topicDescription
                );
        }
    }
}
