package ru.yandex.infra.stage.podspecs.patcher.monitoring;

import java.util.Set;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;

public final class MonitoringPatcherUtils {

    private MonitoringPatcherUtils() {
    }

    public static final String ITYPE_KEY = "itype";
    public static final String PRJ_KEY = "prj";
    public static final String ITYPE_DEPLOY = "deploy";
    public static final String ITYPE_POD_AGENT = "pod_agent";

    public static final String ENV_VARS_PREFIX = "YASM";

    @VisibleForTesting
    static final String STAGE_KEY = "stage";

    @VisibleForTesting
    static final String DEPLOY_UNIT_KEY = "deploy_unit";

    @VisibleForTesting
    static final String WORKLOAD_KEY = "workload";

    public static final Set<String> DEPLOY_LABELS = ImmutableSet.of(STAGE_KEY, DEPLOY_UNIT_KEY,
            "volume", "box");
}
