package ru.yandex.infra.stage.podspecs.patcher.network;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.TPodTemplateSpec;

import static ru.yandex.infra.stage.podspecs.patcher.defaults.DefaultsPatcherV1Base.BACKBONE_VLAN;

public class NetworkPatcherV1 implements SpecPatcher<TPodTemplateSpec.Builder> {

    public final static int NEW_BACKBONE_PRIORITY = 1;

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {

        podTemplateSpecBuilder.getSpecBuilder().getIp6AddressRequestsBuilderList().stream()
                .filter(request -> request.getVlanId().equals(BACKBONE_VLAN))
                .forEach(request -> request.setPriority(NEW_BACKBONE_PRIORITY));
    }
}
