package ru.yandex.infra.stage.podspecs.patcher.network;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TPodTemplateSpec;

public class NetworkPatcherV2 implements SpecPatcher<TPodTemplateSpec.Builder> {

    public static final String LABEL_NAME_IP_LIMIT = "ip_limit";
    private final NetworkPatcherV1 networkPatcherV1 = new NetworkPatcherV1();


    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        networkPatcherV1.patch(podTemplateSpecBuilder, context, labelsBuilder);
        enableIpLimits(podTemplateSpecBuilder.getSpecBuilder(), context);
        enableExtraRoutes(podTemplateSpecBuilder.getSpecBuilder(), context);
    }

    private void enableIpLimits(DataModel.TPodSpec.Builder specBuilder, DeployUnitContext context) {
        if (!context.getStageContext().getLabels().containsKey(LABEL_NAME_IP_LIMIT)) {
            specBuilder.getNetworkSettingsBuilder().setIpLimit(true);
        }
    }

    private void enableExtraRoutes(DataModel.TPodSpec.Builder specBuilder, DeployUnitContext context) {
        if (context.getSpec().getDetails().getPodSpec().getNetworkSettings().getExtraRoutes()) {
            specBuilder.getNetworkSettingsBuilder().setExtraRoutes(true);
        }
    }
}
