package ru.yandex.infra.stage.podspecs.patcher.network;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.dto.NetworkDefaults;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TPodTemplateSpec;
import ru.yandex.yt.ytree.TAttributeDictionary;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.hasLabel;
import static ru.yandex.infra.stage.podspecs.PodSpecUtils.ip6Request;
import static ru.yandex.infra.stage.podspecs.patcher.defaults.DefaultsPatcherV1Base.BACKBONE_VLAN;
import static ru.yandex.infra.stage.podspecs.patcher.defaults.DefaultsPatcherV1Base.BOXES_SUBNET_LABEL;
import static ru.yandex.infra.stage.podspecs.patcher.defaults.DefaultsPatcherV1Base.FASTBONE_VLAN;

public class NetworkPatcherV3 implements SpecPatcher<TPodTemplateSpec.Builder> {

    private final NetworkPatcherV2 networkPatcherV2 = new NetworkPatcherV2();

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {

        DataModel.TPodSpec.Builder podSpec = podTemplateSpecBuilder.getSpecBuilder();
        NetworkDefaults networkDefaults = context.getSpec().getNetworkDefaults();
        if (networkDefaults.isOverrideIp6AddressRequests()) {
            podSpec.clearIp6AddressRequests();
        }
        if (podSpec.getIp6AddressRequestsCount() == 0) {
            podSpec.addIp6AddressRequests(ip6Request(networkDefaults.getNetworkId(), BACKBONE_VLAN));
            podSpec.addIp6AddressRequests(ip6Request(networkDefaults.getNetworkId(), FASTBONE_VLAN));
        }
        if (networkDefaults.isOverrideIp6SubnetRequests()) {
            podSpec.clearIp6SubnetRequests();
        }
        if (podSpec.getIp6SubnetRequestsList().stream()
                .noneMatch(request -> hasLabel(request.getLabels(), BOXES_SUBNET_LABEL))) {
            podSpec.addIp6SubnetRequests(DataModel.TPodSpec.TIP6SubnetRequest.newBuilder()
                    .setNetworkId(networkDefaults.getNetworkId())
                    .setVlanId(BACKBONE_VLAN)
                    .setLabels(TAttributeDictionary.newBuilder()
                            .addAttributes(BOXES_SUBNET_LABEL))
                    .build());
        }
        podSpec.getIp6AddressRequestsBuilderList().forEach(v -> {
            if (v.getVlanId().equals(BACKBONE_VLAN)) {
                if (!networkDefaults.getVirtualServiceIds().isEmpty()) {
                    v.addAllVirtualServiceIds(networkDefaults.getVirtualServiceIds());
                }
                networkDefaults.getIp4AddressPoolId().ifPresent(v::setIp4AddressPoolId);
            }
        });

        networkPatcherV2.patch(podTemplateSpecBuilder, context, labelsBuilder);
    }

}
