package ru.yandex.infra.stage.podspecs.patcher.pod_agent;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TPodTemplateSpec;

//TODO: It was made temporary only for extracting pod agent to another cgroup. (see DEPLOY-1515)
public class PodAgentPatcherV1 implements SpecPatcher<TPodTemplateSpec.Builder> {
    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        DataModel.TPodSpec.TResourceRequests resourceRequests =
                context.getSpec().getDetails().getPodSpec().getResourceRequests();

        DataModel.TPodSpec.TPodAgentContainerResources.Builder computeResourcesBuilder =
                podTemplateSpecBuilder.getSpecBuilder().getPodAgentPayloadBuilder().getMetaBuilder().getComputeResourcesBuilder();

        if (resourceRequests.hasVcpuLimit()) {
            computeResourcesBuilder.setVcpuLimit(resourceRequests.getVcpuLimit());
        }
        if (resourceRequests.hasVcpuGuarantee()) {
            computeResourcesBuilder.setVcpuGuarantee(resourceRequests.getVcpuGuarantee());
        }
        if (resourceRequests.hasMemoryLimit()) {
            computeResourcesBuilder.setMemoryLimit(resourceRequests.getMemoryLimit());
        }
        if (resourceRequests.hasMemoryGuarantee()) {
            computeResourcesBuilder.setMemoryGuarantee(resourceRequests.getMemoryGuarantee());
        }
        if (resourceRequests.hasAnonymousMemoryLimit()) {
            computeResourcesBuilder.setAnonymousMemoryLimit(resourceRequests.getAnonymousMemoryLimit());
        }
        if (resourceRequests.hasThreadLimit()) {
            computeResourcesBuilder.setThreadLimit(resourceRequests.getThreadLimit());
        }

    }
}
