package ru.yandex.infra.stage.podspecs.patcher.portoworkload;

import java.util.Map;
import java.util.regex.Pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.PodSpecUtils;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TMonitoringInfo;
import ru.yandex.yp.client.api.TPodTemplateSpec;

public class PortoWorkloadPatcherV1 implements SpecPatcher<TPodTemplateSpec.Builder> {

    @VisibleForTesting
    static final String PREFIX = "deploy_sidecar";

    @VisibleForTesting
    static final Map<Pattern, String> INFRA_SIDECARS = ImmutableMap.of(
            Pattern.compile("tvm_workload"), "tvm",
            Pattern.compile("logbroker_push_agent_workload"), "logs",
            Pattern.compile(".+_.+__dru"), "dru",
            Pattern.compile(".+-juggler-workload"), "juggler"
    );

    public PortoWorkloadPatcherV1(PortoWorkloadPatcherV1Context context) {
    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {

        if (context.getSpec().isCollectPortometricsFromSidecars()) {
            patchPodSpec(podTemplateSpecBuilder.getSpecBuilder());
        }
    }

    private void patchPodSpec(DataModel.TPodSpec.Builder builder) {
        TMonitoringInfo.Builder podMonitoringInfo = builder.getHostInfraBuilder().getMonitoringBuilder();
        builder.getPodAgentPayload().getSpec().getWorkloadsList().forEach(workload -> {
            var workloadId = workload.getId();
            INFRA_SIDECARS.keySet().stream()
                    .filter(pattern -> pattern.matcher(workloadId).matches())
                    .findFirst()
                    .ifPresent(key -> PodSpecUtils.addSidecarMonitoring(podMonitoringInfo, workloadId,
                            String.format("%s_%s", PREFIX, INFRA_SIDECARS.get(key))));
        });
    }
}
