package ru.yandex.infra.stage.podspecs.patcher.sandbox;

import java.util.List;
import java.util.Map;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.TPodTemplateSpec;
import ru.yandex.yp.client.pods.TLayer;
import ru.yandex.yp.client.pods.TPodAgentSpec;
import ru.yandex.yp.client.pods.TResource;
import ru.yandex.yp.client.pods.TResourceGang;

abstract class SandboxPatcherV1Base implements SpecPatcher<TPodTemplateSpec.Builder> {

    public SandboxPatcherV1Base(SandboxPatcherV1Context context) {
        this();
    }

    public SandboxPatcherV1Base() {

    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        patchPodAgentSpec(podTemplateSpecBuilder.getSpecBuilder().getPodAgentPayloadBuilder().getSpecBuilder(), context);
    }

    private void patchPodAgentSpec(TPodAgentSpec.Builder agentSpec, DeployUnitContext context) {
        Map<String, String> resolvedResources = context.getResolvedSbr();
        if (resolvedResources.isEmpty()) {
            return;
        }

        TResourceGang.Builder resourceGang = agentSpec.getResourcesBuilder();
        List<TResource> resourceList = resourceGang.getStaticResourcesList();

        for (int i = 0; i < resourceList.size(); i++) {
            TResource resource = resourceList.get(i);
            String resolvedUrl = resolvedResources.get(resource.getId());
            if (resolvedUrl != null) {
                resourceGang.setStaticResources(i, resource.toBuilder().setUrl(resolvedUrl));
            }
        }

        List<TLayer> layersList = resourceGang.getLayersList();
        for (int i = 0; i < layersList.size(); i++) {
            TLayer layer = layersList.get(i);
            String resolvedUrl = resolvedResources.get(layer.getId());
            if (resolvedUrl != null) {
                resourceGang.setLayers(i, layer.toBuilder().setUrl(resolvedUrl));
            }
        }
    }
}
