package ru.yandex.infra.stage.podspecs.patcher.security;

import java.util.Objects;

public final class FoldersLayerUrls {

    private final String podAgentFoldersLayerUrl;
    private final String portoshellFoldersLayerUrl;
    private final String coredumpFoldersLayerUrl;
    private final String logbrokerFoldersLayerUrl;
    private final String jugglerFoldersLayerUrl;
    private final String logrotateFoldersLayerUrl;

    public FoldersLayerUrls(
            String podAgentFoldersLayerUrl,
            String portoshellFoldersLayerUrl,
            String coredumpFoldersLayerUrl,
            String logbrokerFoldersLayerUrl,
            String jugglerFoldersLayerUrl,
            String logrotateFoldersLayerUrl
    ) {
        this.podAgentFoldersLayerUrl = podAgentFoldersLayerUrl;
        this.portoshellFoldersLayerUrl = portoshellFoldersLayerUrl;
        this.coredumpFoldersLayerUrl = coredumpFoldersLayerUrl;
        this.logbrokerFoldersLayerUrl = logbrokerFoldersLayerUrl;
        this.jugglerFoldersLayerUrl = jugglerFoldersLayerUrl;
        this.logrotateFoldersLayerUrl = logrotateFoldersLayerUrl;
    }

    public String getPodAgentFoldersLayerUrl() {
        return podAgentFoldersLayerUrl;
    }
    public String getPortoshellFoldersLayerUrl() {
        return portoshellFoldersLayerUrl;
    }
    public String getCoredumpFoldersLayerUrl() {
        return coredumpFoldersLayerUrl;
    }
    public String getLogbrokerFoldersLayerUrl() { return logbrokerFoldersLayerUrl; }
    public String getJugglerFoldersLayerUrl() { return jugglerFoldersLayerUrl; }
    public String getLogrotateFoldersLayerUrl() { return logrotateFoldersLayerUrl; }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FoldersLayerUrls that = (FoldersLayerUrls) o;
        return Objects.equals(podAgentFoldersLayerUrl, that.podAgentFoldersLayerUrl) && Objects.equals(portoshellFoldersLayerUrl, that.portoshellFoldersLayerUrl) && Objects.equals(coredumpFoldersLayerUrl, that.coredumpFoldersLayerUrl) && Objects.equals(logbrokerFoldersLayerUrl, that.logbrokerFoldersLayerUrl) && Objects.equals(jugglerFoldersLayerUrl, that.jugglerFoldersLayerUrl) && Objects.equals(logrotateFoldersLayerUrl, that.logrotateFoldersLayerUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(podAgentFoldersLayerUrl, portoshellFoldersLayerUrl, coredumpFoldersLayerUrl, logbrokerFoldersLayerUrl, jugglerFoldersLayerUrl, logrotateFoldersLayerUrl);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("FoldersLayerUrls{");
        sb.append("podAgentFoldersLayerUrl='").append(podAgentFoldersLayerUrl).append('\'');
        sb.append(", portoshellFoldersLayerUrl='").append(portoshellFoldersLayerUrl).append('\'');
        sb.append(", coredumpFoldersLayerUrl='").append(coredumpFoldersLayerUrl).append('\'');
        sb.append(", logbrokerFoldersLayerUrl='").append(logbrokerFoldersLayerUrl).append('\'');
        sb.append(", jugglerFoldersLayerUrl='").append(jugglerFoldersLayerUrl).append('\'');
        sb.append(", logrotateFoldersLayerUrl='").append(logrotateFoldersLayerUrl).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
