package ru.yandex.infra.stage.podspecs.patcher.security;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;

public final class SecurityPatcherV1Context {

    private final ResourceSupplier defaultPodAgentBinarySupplier;
    private final long firstAffectedPodAgentBinaryVersion;
    private final FoldersLayerUrls foldersLayerUrls;

    public SecurityPatcherV1Context(ResourceSupplier defaultPodAgentBinarySupplier,
                                    long firstAffectedPodAgentBinaryVersion,
                                    FoldersLayerUrls foldersLayerUrls) {
        this.defaultPodAgentBinarySupplier = defaultPodAgentBinarySupplier;
        this.firstAffectedPodAgentBinaryVersion = firstAffectedPodAgentBinaryVersion;
        this.foldersLayerUrls = foldersLayerUrls;
    }

    public ResourceSupplier getDefaultPodAgentBinarySupplier() {
        return defaultPodAgentBinarySupplier;
    }

    public long getFirstAffectedPodAgentBinaryVersion() {
        return firstAffectedPodAgentBinaryVersion;
    }

    public FoldersLayerUrls getFoldersLayerUrls() { return foldersLayerUrls; }

    @VisibleForTesting
    SecurityPatcherV1Context.Builder toBuilder() {
        return new SecurityPatcherV1Context.Builder(this);
    }

    static class Builder {

        private ResourceSupplier defaultPodAgentBinarySupplier;
        private long firstAffectedPodAgentBinaryVersion;
        private FoldersLayerUrls foldersLayerUrls;

        Builder(SecurityPatcherV1Context context) {
            this.defaultPodAgentBinarySupplier = context.defaultPodAgentBinarySupplier;
            this.firstAffectedPodAgentBinaryVersion = context.firstAffectedPodAgentBinaryVersion;
            this.foldersLayerUrls = context.getFoldersLayerUrls();
        }

        SecurityPatcherV1Context.Builder withDefaultPodAgentBinarySupplier(ResourceSupplier defaultPodAgentBinarySupplier) {
            this.defaultPodAgentBinarySupplier = defaultPodAgentBinarySupplier;
            return this;
        }

        SecurityPatcherV1Context.Builder withFirstAffectedPodAgentBinaryVersion(long firstAffectedPodAgentBinaryVersion) {
            this.firstAffectedPodAgentBinaryVersion = firstAffectedPodAgentBinaryVersion;
            return this;
        }

        SecurityPatcherV1Context.Builder withFoldersLayerUrls(FoldersLayerUrls foldersLayerUrls) {
            this.foldersLayerUrls = foldersLayerUrls;
            return this;
        }

        SecurityPatcherV1Context build() {
            return new SecurityPatcherV1Context(
                    defaultPodAgentBinarySupplier,
                    firstAffectedPodAgentBinaryVersion,
                    foldersLayerUrls
            );
        }
    }
}
