package ru.yandex.infra.stage.podspecs.patcher.thread_limits;

import java.util.Optional;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.dto.LogbrokerConfig;
import ru.yandex.infra.stage.dto.TvmConfig;
import ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils;
import ru.yandex.yp.client.pods.TPodAgentSpecOrBuilder;

import static ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils.LOGBROKER_THREAD_LIMIT;
import static ru.yandex.infra.stage.podspecs.patcher.thread_limits.ThreadLimitsPatcherUtils.MAX_AVAILABLE_THREADS_PER_POD;
import static ru.yandex.infra.stage.podspecs.patcher.tvm.TvmPatcherUtils.TVM_THREAD_LIMIT;

public class ThreadLimitsPatcherV1 extends ThreadLimitsPatcherV1Base {

    @VisibleForTesting
    static final long POD_AGENT_RESERVED_THREAD_COUNT = 100;

    public ThreadLimitsPatcherV1(ThreadLimitsPatcherV1Context context) {
        super(context);
    }

    @Override
    public long getThreadLimitsAvailableForUserBoxes(TPodAgentSpecOrBuilder podAgentSpec,
                                                     LogbrokerConfig logbrokerConfig,
                                                     Optional<TvmConfig> tvmConfig) {
        long maxAvailableThreadsPerUserBoxes = MAX_AVAILABLE_THREADS_PER_POD - POD_AGENT_RESERVED_THREAD_COUNT;

        if (isTvmUsed(tvmConfig)) {
            maxAvailableThreadsPerUserBoxes -= TVM_THREAD_LIMIT;
        }

        if (LogbrokerPatcherUtils.useLogbrokerTools(podAgentSpec, logbrokerConfig)) {
            maxAvailableThreadsPerUserBoxes -= LOGBROKER_THREAD_LIMIT;
        }
        return maxAvailableThreadsPerUserBoxes;
    }

    private boolean isTvmUsed(Optional<TvmConfig> tvmConfig) {
        return tvmConfig.map(TvmConfig::isEnabled).orElse(false);
    }
}
