package ru.yandex.infra.stage.podspecs.patcher.thread_limits;

import java.util.Optional;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.dto.LogbrokerConfig;
import ru.yandex.infra.stage.dto.TvmConfig;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.TPodTemplateSpec;
import ru.yandex.yp.client.pods.TPodAgentSpec;
import ru.yandex.yp.client.pods.TPodAgentSpecOrBuilder;


/**
 * Distributes spare threads between user boxes without set up thread limits
 */
abstract class ThreadLimitsPatcherV1Base implements SpecPatcher<TPodTemplateSpec.Builder> {

    private final ThreadLimitsPatcherV1Context context;

    public ThreadLimitsPatcherV1Base(ThreadLimitsPatcherV1Context context) {
        this.context = context;
    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context, YTreeBuilder labelsBuilder) {
        patchUserBoxesThreadLimit(podTemplateSpecBuilder.getSpecBuilder().getPodAgentPayloadBuilder().getSpecBuilder(), context);
    }

    private void patchUserBoxesThreadLimit(TPodAgentSpec.Builder podAgentSpec, DeployUnitContext deployUnitContext) {
        long threadsForUserBoxes = getThreadLimitsAvailableForUserBoxes(
                podAgentSpec,
                deployUnitContext.getSpec().getLogbrokerConfig(),
                deployUnitContext.getSpec().getTvmConfig()
        );

        context.getBoxThreadLimitsDistributor()
                .distributeThreadLimitsAvailableForUserBoxes(podAgentSpec, threadsForUserBoxes);
    }

    protected long getThreadLimitsAvailableForUserBoxes(TPodAgentSpecOrBuilder podAgentSpec,
                                                        LogbrokerConfig logbrokerConfig,
                                                        Optional<TvmConfig> tvmConfig) {
        return ThreadLimitsPatcherUtils.maxAvailableThreadsToUserBoxesForValidation();
    }
}
