package ru.yandex.infra.stage.podspecs.patcher.thread_limits;

import ru.yandex.infra.stage.podspecs.patcher.thread_limits.box.BoxThreadLimitsDistributor;

public class ThreadLimitsPatcherV1Context {

    private final BoxThreadLimitsDistributor boxThreadLimitsDistributor;

    public ThreadLimitsPatcherV1Context(BoxThreadLimitsDistributor boxThreadLimitsDistributor) {
        this.boxThreadLimitsDistributor = boxThreadLimitsDistributor;
    }

    public BoxThreadLimitsDistributor getBoxThreadLimitsDistributor() {
        return boxThreadLimitsDistributor;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private BoxThreadLimitsDistributor boxThreadLimitsDistributor;

        private Builder(ThreadLimitsPatcherV1Context context) {
            this.boxThreadLimitsDistributor = context.boxThreadLimitsDistributor;
        }

        public ThreadLimitsPatcherV1Context build() {
            return new ThreadLimitsPatcherV1Context(boxThreadLimitsDistributor);
        }

        public Builder with(BoxThreadLimitsDistributor boxThreadLimitsDistributor) {
            this.boxThreadLimitsDistributor = boxThreadLimitsDistributor;
            return this;
        }
    }
}
