package ru.yandex.infra.stage.podspecs.patcher.thread_limits.box;

import java.util.LinkedList;
import java.util.List;

import ru.yandex.infra.stage.podspecs.patcher.PatcherUtils;
import ru.yandex.yp.client.pods.TBox;
import ru.yandex.yp.client.pods.TPodAgentSpec;

public class BoxThreadLimitsDistributorImpl implements BoxThreadLimitsDistributor {

    public final static BoxThreadLimitsDistributorImpl INSTANCE = new BoxThreadLimitsDistributorImpl();

    private BoxThreadLimitsDistributorImpl() {}

    @Override
    public void distributeThreadLimitsAvailableForUserBoxes(TPodAgentSpec.Builder podAgentSpec,
                                                            long threadsToDistribute) {
        List<TBox.Builder> userBoxesWithoutThreadLimit = new LinkedList<>();

        for (var box : PatcherUtils.notSystemBoxes(podAgentSpec.getBoxesBuilderList())) {
            if (box.getComputeResources().getThreadLimit() == 0) {
                userBoxesWithoutThreadLimit.add(box);
            } else {
                threadsToDistribute -= box.getComputeResources().getThreadLimit();
            }
        }

        if (!userBoxesWithoutThreadLimit.isEmpty()) {
            long threadsPerUserBox = threadsToDistribute / userBoxesWithoutThreadLimit.size();
            userBoxesWithoutThreadLimit.forEach(boxBuilder -> boxBuilder.getComputeResourcesBuilder()
                    .setThreadLimit(threadsPerUserBox));
        }
    }
}
