package ru.yandex.infra.stage.podspecs.patcher.thread_limits.pod_agent;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.infra.stage.podspecs.patcher.pod_agent.PodAgentPatcherUtils;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.yp.client.api.TPodTemplateSpec;

abstract class PodAgentThreadLimitPatcherV1Base implements SpecPatcher<TPodTemplateSpec.Builder> {

    public PodAgentThreadLimitPatcherV1Base(PodAgentThreadLimitPatcherV1Context context) {
        this();
    }

    public PodAgentThreadLimitPatcherV1Base() {
    }

    @Override
    public void patch(TPodTemplateSpec.Builder podTemplateSpecBuilder, DeployUnitContext context,
                      YTreeBuilder labelsBuilder) {

        var resources = podTemplateSpecBuilder
                .getSpecBuilder()
                .getPodAgentPayloadBuilder()
                .getMetaBuilder()
                .getComputeResourcesBuilder();

        if (resources.hasThreadLimit()) {
            return;
        }

        resources.setThreadLimit(PodAgentPatcherUtils.POD_AGENT_THREAD_LIMIT_V1_TO_LAST);
    }
}
