package ru.yandex.infra.stage.podspecs.patcher.tvm;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.dto.AllComputeResources;
import ru.yandex.infra.stage.dto.TvmConfig;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.MEGABYTE;

public class TvmPatcherV1 extends TvmPatcherV1Base {

    public TvmPatcherV1(TvmPatcherV1Context context) {
        super(context);
    }

    @VisibleForTesting
    public AllComputeResources getTvmBoxComputingResource(long diskSpaceMb, TvmConfig tvmConfig, long threadLimit) {
        //Looks like a bug, fixed in TvmPatcherV2,
        //  but we should keep this logic in TvmPatcherV1 to prevent allocations (TvmBox resouce request change)
        boolean isPodAdditionalResources = threadLimit == 0;

        return new AllComputeResources(
                isPodAdditionalResources ? tvmConfig.getCpuLimit() : TvmConfig.DEFAULT_CPU_LIMIT,
                (isPodAdditionalResources ? tvmConfig.getMemoryLimitMb() : TvmConfig.DEFAULT_MEMORY_LIMIT_MB) * MEGABYTE,
                diskSpaceMb * MEGABYTE,
                threadLimit
        );
    }

    @Override
    public boolean shouldAddTvmConfigEnvVar() {
        return false;
    }

    @Override
    protected String getTvmBoxId() {
        return TvmPatcherUtils.TVM_BOX_ID_UNDERSCORED;
    }
}
