package ru.yandex.infra.stage.podspecs.patcher.tvm;

import ru.yandex.infra.stage.dto.AllComputeResources;
import ru.yandex.infra.stage.dto.TvmConfig;

import static ru.yandex.infra.stage.podspecs.PodSpecUtils.MEGABYTE;

public class TvmPatcherV2 extends TvmPatcherV1Base {

    public TvmPatcherV2(TvmPatcherV1Context context) {
        super(context);
    }

    @Override
    public AllComputeResources getTvmBoxComputingResource(long diskSpaceMb, TvmConfig tvmConfig, long threadLimit) {
        return new AllComputeResources(
                tvmConfig.getCpuLimit(),
                tvmConfig.getMemoryLimitMb() * MEGABYTE,
                diskSpaceMb * MEGABYTE,
                threadLimit
        );
    }

    @Override
    public boolean shouldAddTvmConfigEnvVar() {
        return false;
    }

    @Override
    protected String getTvmBoxId() {
        return TvmPatcherUtils.TVM_BOX_ID_UNDERSCORED;
    }
}
