package ru.yandex.infra.stage.podspecs.revision;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.google.protobuf.Message;

import ru.yandex.infra.stage.podspecs.SpecPatcher;
import ru.yandex.infra.stage.podspecs.revision.model.RevisionScheme;


public class RevisionsHolderImpl<T extends Message.Builder> implements RevisionsHolder<T> {

    private final Map<Integer, List<SpecPatcher<T>>> revisionIdToPatchers;
    private final int fallbackRevisionId;

    public RevisionsHolderImpl(Map<Integer, List<SpecPatcher<T>>> revisionIdToPatchers, int fallbackRevisionId) {
        this.revisionIdToPatchers = revisionIdToPatchers;
        this.fallbackRevisionId = fallbackRevisionId;
    }

    @Override
    public boolean containsRevision(int revisionId) {
        return RevisionScheme.DEFAULT_REVISION_ID == revisionId || revisionIdToPatchers.containsKey(revisionId);
    }

    @Override
    public Optional<List<SpecPatcher<T>>> getPatchersFor(int revisionId) {
        if (RevisionScheme.DEFAULT_REVISION_ID == revisionId) {
            revisionId = fallbackRevisionId;
        }

        return Optional.ofNullable(revisionIdToPatchers.get(revisionId));
    }
}
