package ru.yandex.infra.stage.podspecs.revision.model;

import java.util.Arrays;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CompositeInfo {

    private final String[] patcherNamesOrder;

    public CompositeInfo(@JsonProperty("order") String[] patcherNamesOrder) {
        this.patcherNamesOrder = patcherNamesOrder;
    }

    public String[] getPatcherNamesOrder() {
        return patcherNamesOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompositeInfo that = (CompositeInfo) o;
        return Arrays.equals(patcherNamesOrder, that.patcherNamesOrder);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(patcherNamesOrder);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("patcherNamesOrder", Arrays.toString(patcherNamesOrder))
                .toString();
    }
}
