package ru.yandex.infra.stage.podspecs.revision.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class PatcherClassInfo {

    private final String className;
    private final String classPackage;

    PatcherClassInfo(@JsonProperty("package") String classPackage,
                     @JsonProperty("class_name") String className) {
        this.classPackage = classPackage;
        this.className = className;
    }

    @VisibleForTesting
    String getClassName() {
        return className;
    }

    public String getPatcherFullPackageName(String basePatchersPackage) {
        return basePatchersPackage + "." + classPackage;
    }

    public String getPatcherFullClassName(String basePatchersPackage) {
        String fullPackage = getPatcherFullPackageName(basePatchersPackage);

        return String.format(
                "%s.%s", fullPackage, className
        );
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (null == obj) {
            return false;
        }

        if (!(obj instanceof PatcherClassInfo)) {
            return false;
        }

        PatcherClassInfo other = (PatcherClassInfo) obj;
        return Objects.equals(classPackage, other.classPackage)
                && Objects.equals(className, other.className);
    }

    @Override
    public int hashCode() {
        return Objects.hash(classPackage, className);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("classPackage", classPackage)
                .add("className", className)
                .toString();
    }
}
