package ru.yandex.infra.stage.podspecs.revision.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class Revision {

    private final int id;
    private final String description;

    private final SpecInfo podSpecInfo;
    private final SpecInfo endpointSetSpecInfo;


    public Revision(@JsonProperty("id") int id,
                    @JsonProperty("description") String description,
                    @JsonProperty("pod_spec") SpecInfo podSpecInfo,
                    @JsonProperty("endpoint_set_spec") SpecInfo endpointSetSpecInfo) {
        this.id = id;
        this.description = description;
        this.podSpecInfo = podSpecInfo;
        this.endpointSetSpecInfo = endpointSetSpecInfo;
    }

    public int getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }


    public SpecInfo getPodSpecInfo() {
        return podSpecInfo;
    }

    public SpecInfo getEndpointSetSpecInfo() {
        return endpointSetSpecInfo;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("description", description)
                .add("podSpecInfo", podSpecInfo)
                .add("endpointSetSpecInfo", endpointSetSpecInfo)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Revision revision = (Revision) o;
        return Objects.equal(id, revision.id) && Objects.equal(description, revision.description) && Objects.equal(podSpecInfo,
                revision.podSpecInfo) && Objects.equal(endpointSetSpecInfo, revision.endpointSetSpecInfo);
    }


    @Override
    public int hashCode() {
        return Objects.hashCode(id, description, podSpecInfo, endpointSetSpecInfo);
    }

}
