package ru.yandex.infra.stage.podspecs.revision.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.podspecs.revision.RevisionSchemeException;
import ru.yandex.misc.io.cl.ClassLoaderUtils;

import static ru.yandex.infra.stage.util.JsonUtils.DEFAULT_MAPPER;

public class RevisionScheme {

    public static final int DEFAULT_REVISION_ID = 0;

    public static RevisionScheme loadFromResource(String revisionSchemeFileName) {
        try {
            InputStream revisionSchemaInputStream =
                    ClassLoaderUtils.streamSourceForResource(revisionSchemeFileName).getInput();
            return DEFAULT_MAPPER.readValue(revisionSchemaInputStream, RevisionScheme.class);
        } catch (IOException e) {
            throw new RevisionSchemeException("Revision scheme load from json file error", e);
        }
    }

    private final Revision[] revisions;
    private final int fallbackRevisionId;

    public RevisionScheme(@JsonProperty("revisions") Revision[] revisions,
                          @JsonProperty("fallback") int fallbackRevisionId) {
        this.revisions = revisions;
        this.fallbackRevisionId = fallbackRevisionId;
    }

    public Revision[] getRevisions() {
        return revisions;
    }

    public int getFallbackRevisionId() {
        return fallbackRevisionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RevisionScheme that = (RevisionScheme) o;
        return fallbackRevisionId == that.fallbackRevisionId &&
                Arrays.equals(revisions, that.revisions);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(fallbackRevisionId);
        result = 31 * result + Arrays.hashCode(revisions);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("revisions", Arrays.toString(revisions))
                .add("fallbackRevisionId", fallbackRevisionId)
                .toString();
    }
}
