package ru.yandex.infra.stage.podspecs.revision.model;

import java.util.Arrays;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class SpecInfo {
    private final PatcherClassInfo[] patcherClassInfos;
    private final CompositeInfo compositeInfo;


    public SpecInfo(
            @JsonProperty("spec_patchers") PatcherClassInfo[] patcherClassInfos,
            @JsonProperty("spec_composite") CompositeInfo compositeInfo) {
        this.patcherClassInfos = patcherClassInfos;
        this.compositeInfo = compositeInfo;
    }

    public PatcherClassInfo[] getPatcherClassInfos() {
        return patcherClassInfos;
    }

    public CompositeInfo getCompositeInfo() {
        return compositeInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SpecInfo specInfo = (SpecInfo) o;
        return Arrays.equals(patcherClassInfos, specInfo.patcherClassInfos) && Objects.equal(compositeInfo,
                specInfo.compositeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(patcherClassInfos, compositeInfo);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("patcherClassInfos", patcherClassInfos)
                .add("compositeInfo", compositeInfo)
                .toString();
    }
}
