package ru.yandex.infra.stage.primitives;

import ru.yandex.infra.stage.deployunit.DeployUnitContext;
import ru.yandex.infra.stage.deployunit.DeployUnitStats;
import ru.yandex.infra.stage.dto.DeployUnitSpecDetails;
import ru.yandex.infra.stage.dto.datamodel.AntiaffinityConstraint;

// TODO fix(?) using of raw type (without <>)
public interface DeployPrimitiveController<Spec extends DeployUnitSpecDetails> {
    AntiaffinityConstraint DEFAULT_CONSTRAINT = AntiaffinityConstraint.node(1);
    String STAGE_LABEL_KEY = "stage_id";
    String DEPLOY_LABEL_KEY = "deploy";
    String DISABLED_CLUSTERS_LABEL_KEY = "disabled_clusters";

    void sync(Spec spec, DeployUnitContext context);

    void shutdown();

    AggregatedRawStatus getStatus();

    void addStats(DeployUnitStats.Builder builder);
}
