package ru.yandex.infra.stage.protobuf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConverterUtils {
    private ConverterUtils() {}

    public static <T, U> List<T> convertList(
            Collection<U> collection, Function<U, T> converter
    ) {
        return collection.stream().map(converter).collect(Collectors.toList());
    }

    public static <T, U> SortedMap<String, U> convertMap(
            Map<String, T> sourceMap, Function<T, U> converter
    ) {
        return sourceMap.entrySet().stream()
                .collect(TreeMap::new, (map, entry) -> map.put(entry.getKey(), converter.apply(entry.getValue())), TreeMap::putAll);
    }

    public static long fromUInt32ToLong(int protoUInt32) {
        long res = protoUInt32;
        if (res < 0) res += (1L << 32);
        return res;
    }
}

