package ru.yandex.infra.stage.protobuf;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.protobuf.ProtocolMessageEnum;

// Copypasted from iss repository https://bb.yandex-team.ru/projects/SEARCH_INFRA/repos/iss/browse
public class EnumByMapConverter<JavaEnum extends Enum, ProtoEnum extends ProtocolMessageEnum> {
    private final Map<JavaEnum, ProtoEnum> javaToProto;
    private final Map<ProtoEnum, JavaEnum> protoToJava;

    public EnumByMapConverter(Class<JavaEnum> javaClass, Class<ProtoEnum> protoClass,
                              Map<JavaEnum, ProtoEnum> javaToProto) {
        this.javaToProto = javaToProto;
        this.protoToJava = javaToProto.entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        assertAllConstantsPresent(javaClass, javaToProto.keySet());
        assertAllConstantsPresent(protoClass, protoToJava.keySet());
    }

    private void assertAllConstantsPresent(Class<?> enumClass, Set<?> keySet) {
        Optional<?> notPresent = Arrays.stream(enumClass.getEnumConstants()).filter(name -> !keySet.contains(name)).findFirst();
        notPresent.ifPresent(name -> {
            String message = String.format("No mapping for constant %s from class %s", name, enumClass.getCanonicalName());
            throw new IllegalArgumentException(message);
        });
    }

    public ProtoEnum toProto(JavaEnum java) {
        return javaToProto.get(java);
    }

    public JavaEnum fromProto(ProtoEnum proto) {
        return protoToJava.get(proto);
    }
}

