package ru.yandex.infra.stage.rest;

import java.util.Set;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GarbageForceCollectHandler extends HttpServlet {
    private final Set<GarbageRequestReceiver> requestReceivers;

    public GarbageForceCollectHandler(Set<GarbageRequestReceiver> requestReceivers) {
        this.requestReceivers = requestReceivers;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        GarbageHandlerUtils.findRequestReceiver(requestReceivers, GarbageHandlerUtils.getClusterAndType(req)).forceCollectGarbage();
        resp.setStatus(HttpServletResponse.SC_OK);
    }
}
