package ru.yandex.infra.stage.rest;

import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.stage.dto.ClusterAndType;
import ru.yandex.yp.model.YpObjectType;

public class GarbageHandlerUtils {
    public final static Map<String, YpObjectType> TYPE_BY_STRING = Map.of(
            "mcrs", YpObjectType.MULTI_CLUSTER_REPLICA_SET,
            "multi_cluster_replica_set", YpObjectType.MULTI_CLUSTER_REPLICA_SET,
            "rs", YpObjectType.REPLICA_SET,
            "replica_set", YpObjectType.REPLICA_SET,
            "dynamic_resource", YpObjectType.DYNAMIC_RESOURCE,
            "resource_cache", YpObjectType.RESOURCE_CACHE,
            "horizontal_pod_autoscaler", YpObjectType.HORIZONTAL_POD_AUTOSCALER,
            "endpoint_set", YpObjectType.ENDPOINT_SET
    );

    public static ClusterAndType getClusterAndType(HttpServletRequest req) {
        var type = req.getParameter("type");
        var ypType = TYPE_BY_STRING.get(type.toLowerCase());
        if (ypType == YpObjectType.MULTI_CLUSTER_REPLICA_SET) {
            return ClusterAndType.mcrs();
        }
        if (ypType == null) {
            throw new RuntimeException(String.format("Unknown object type: %s", type));
        }
        var cluster = req.getParameter("cluster");
        return ClusterAndType.perClusterInstance(cluster, ypType);
    }

    public static GarbageRequestReceiver findRequestReceiver(Set<GarbageRequestReceiver> receivers,
                                                             ClusterAndType clusterAndType) {
        var result = receivers.stream()
                .filter(receiver -> receiver.getClusterAndType().equals(clusterAndType))
                .findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new RuntimeException(String.format("Incorrect request arguments: %s", clusterAndType.toString()));
    }
}
