package ru.yandex.infra.stage.rest;

import java.io.IOException;
import java.util.Set;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;

public class GarbageListHandler extends HttpServlet {
    private final Set<GarbageRequestReceiver> requestReceivers;

    public GarbageListHandler(Set<GarbageRequestReceiver> requestReceivers) {
        this.requestReceivers = requestReceivers;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        GarbageHandlerUtils.findRequestReceiver(requestReceivers, GarbageHandlerUtils.getClusterAndType(req))
                .getGarbage().forEach(result::add);
        resp.getWriter().print(mapper.writeValueAsString(result));
        resp.setStatus(HttpServletResponse.SC_OK);
    }
}
