package ru.yandex.infra.stage.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.infra.stage.podspecs.ResourceSupplier;
import ru.yandex.infra.stage.podspecs.SandboxResourceMeta;

import static ru.yandex.infra.stage.util.JsonUtils.DEFAULT_MAPPER;

public class ResourcesServlet extends HttpServlet {
    private final Map<String, ResourceSupplier> suppliers;

    public ResourcesServlet(Map<String, ResourceSupplier> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ObjectNode result = DEFAULT_MAPPER.createObjectNode();
        suppliers.forEach((name, supplier) -> {
            Optional<SandboxResourceMeta> metaOpt = supplier.get().getMeta();
            ObjectNode entry = DEFAULT_MAPPER.createObjectNode();

            metaOpt.ifPresentOrElse(
                    meta -> {
                        entry.put("task_id", meta.getTaskId());
                        entry.put("resource_id", meta.getResourceId());
                        entry.put("state", "resolved");
                    },
                    () -> entry.put("state", "unresolved")
            );
            result.set(name, entry);
        });
        resp.getWriter().print(DEFAULT_MAPPER.writeValueAsString(result));
        resp.setStatus(HttpServletResponse.SC_OK);
    }
}
