package ru.yandex.infra.stage.util;

public interface AdaptiveRateLimiter {
    boolean tryAcquire();
    void registerFailedResponse();
    double getRate();
    int getActiveRequestsCount();
    boolean isActive();

    int incrementAndGet();
    int decrementAndGet();

    AdaptiveRateLimiter EMPTY = new DummyRateLimiter();

    class DummyRateLimiter implements AdaptiveRateLimiter {

        @Override
        public boolean tryAcquire() {
            return true;
        }

        @Override
        public void registerFailedResponse() {
        }

        @Override
        public double getRate() {
            return Double.NaN;
        }

        @Override
        public int getActiveRequestsCount() {
            return 0;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public int incrementAndGet() {
            return 0;
        }

        @Override
        public int decrementAndGet() {
            return 0;
        }
    }

}
