package ru.yandex.infra.stage.util;

import java.util.concurrent.ThreadLocalRandom;

import com.google.common.annotations.VisibleForTesting;

public class GeneralUtils {
    @VisibleForTesting
    static final int DEFAULT_MIN_MILLISECONDS = 0;
    @VisibleForTesting
    static final int DEFAULT_MAX_MILLISECONDS = 30_000;
    public static final int DEFAULT_BACK_OFF_MULTIPLIER = 2;
    public static final String CLUSTER_SEQUENCE = "cluster_sequence";

    public static StoppableBackOff getTimeoutFactory(long initialRetryTimeout, long maxRetryInterval) {
        StoppableExponentialBackOff result = new StoppableExponentialBackOff(initialRetryTimeout, DEFAULT_BACK_OFF_MULTIPLIER);
        result.setMaxInterval(maxRetryInterval);
        return result;
    }

    public static int getJitterMillis(int minMillis, int maxMillis) {
        return minMillis + ThreadLocalRandom.current().nextInt(maxMillis - minMillis + 1);
    }

    public static long getNextBackoffWithJitter(long nextBackoffMillis) {
        int minMillis = DEFAULT_MIN_MILLISECONDS;
        int maxMillis = Math.min(DEFAULT_MAX_MILLISECONDS, (int) nextBackoffMillis);
        if (maxMillis < minMillis) {
            maxMillis = minMillis;
        }
        return nextBackoffMillis + getJitterMillis(minMillis, maxMillis);
    }
}
