package ru.yandex.infra.stage.util;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import one.util.streamex.EntryStream;

public final class JsonUtils {
    private JsonUtils() {}

    public static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    static {
        DEFAULT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static String yamlToJson(String yaml) {
        try {
            ObjectMapper yamlReader = new ObjectMapper(new YAMLFactory());
            Object obj = yamlReader.readValue(yaml, Object.class);

            ObjectMapper jsonWriter = new ObjectMapper();
            return jsonWriter.writeValueAsString(obj);
        }
        catch(IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String jsonToYaml(String json) {
        try {
            ObjectMapper jsonReader = new ObjectMapper();
            Object obj = jsonReader.readValue(json, Object.class);

            ObjectMapper yamlWriter = new ObjectMapper(new YAMLFactory());
            return yamlWriter.writeValueAsString(obj);
        }
        catch(IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJson(Map<String, String> map) {
        var node = DEFAULT_MAPPER.createObjectNode();
        EntryStream.of(map)
                .forKeyValue(node::put);

        try {
            return DEFAULT_MAPPER.writeValueAsString(node);
        } catch (JsonProcessingException e) {
            return "";
        }
    }
}
