package ru.yandex.infra.stage.util;

public class LocalizedRuntimeException extends RuntimeException {

    private final String localizedMessage;

    public LocalizedRuntimeException(String message, String localizedMessage) {
        super(message);
        this.localizedMessage = localizedMessage;
    }

    public LocalizedRuntimeException(String message, String localizedMessage, Throwable cause) {
        super(message, cause);
        this.localizedMessage = localizedMessage;
    }

    @Override
    public String getLocalizedMessage() {
        return localizedMessage;
    }
}
