package ru.yandex.infra.stage.util;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalUtils {
    public static OptionalInt zeroAsEmptyOptional(int x) {
        if (x == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(x);
    }

    public static OptionalLong zeroAsEmptyOptional(long x) {
        if (x == 0) {
            return OptionalLong.empty();
        }

        return OptionalLong.of(x);
    }

    public static Optional<String> emptyStringAsEmptyOptional(String s) {
        // Null check is useful for dealing with external libraries
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(s);
    }
}
