package ru.yandex.infra.stage.util;

import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;

public class StoppableExponentialBackOff extends ExponentialBackOff implements StoppableBackOff {

    public StoppableExponentialBackOff(long initialInterval, double multiplier) {
        super(initialInterval, multiplier);
    }

    @Override
    public BackOffExecution start() {
        return startStoppable();
    }

    @Override
    public StoppableBackOffExecution startStoppable() {
        return new StoppableExponentialBackOffExecution(super.start());
    }

    private static class StoppableExponentialBackOffExecution implements StoppableBackOffExecution {
        private final BackOffExecution backOffExecution;
        private boolean stopped;

        public StoppableExponentialBackOffExecution(BackOffExecution backOffExecution) {
            this.backOffExecution = backOffExecution;
        }

        @Override
        public void stop() {
            stopped = true;
        }

        @Override
        public long nextBackOff() {
            return stopped ? BackOffExecution.STOP : backOffExecution.nextBackOff();
        }
    }
}
