package ru.yandex.infra.stage.util;

import java.util.Collection;
import java.util.stream.Collectors;

public class StringUtils {
    private StringUtils() {}

    public static final String ID_SEPARATOR = ".";
    public static final String ID_SEPARATOR_REGEX = "\\.";

    public static String joinStrings(Collection<String> ids) {
        return ids.stream()
                .map(item -> "'" + item + "'")
                .collect(Collectors.joining(", "));
    }

    public static String selectResourceId(String fullId) {
        return fullId.substring(fullId.lastIndexOf(ID_SEPARATOR) + 1);
    }

    public static String selectUnitId(String fullId) {
        return fullId.substring(0, fullId.indexOf(ID_SEPARATOR));
    }

    public static String escapeUnaryQuotes(String bashArg) {
        return bashArg.replace("'", "'\"'\"'"); // ' -> '"'"'
        // why does it work? let's see
        // [   input ] -> '    output   ' -> in bash - 3 parts join by empty string to one string bkz there aren't spaces
        // [aaa ' aaa] -> 'aaa '"'"' aaa' -> <aaa >{'}< aaa>
        //                                   '    '" "'    '
    }
}
