package ru.yandex.infra.stage.yp;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

import ru.yandex.yp.YpRawObjectService;

public class AsyncYpClientsMap {
    private final Map<String, YpRawObjectService> clusterClients;
    private final YpRawObjectService multiClusterClient;

    public AsyncYpClientsMap(Map<String, YpRawObjectService> clusterClients, YpRawObjectService multiClusterClient) {
        this.clusterClients = clusterClients;
        this.multiClusterClient = multiClusterClient;
    }

    public YpRawObjectService getMultiClusterClient() {
        return multiClusterClient;
    }

    public YpRawObjectService getClusterClient(String cluster) {
        YpRawObjectService result = clusterClients.get(cluster);
        if (result == null) {
            throw new IllegalArgumentException(String.format("No yp client configured for cluster %s", cluster));
        }
        return result;
    }

    public YpRawObjectService getMultiOrClusterClient(Optional<String> cluster) {
        if (cluster.isPresent()) {
            return getClusterClient(cluster.get());
        } else {
            return multiClusterClient;
        }
    }

    public Set<String> getClusters() {
        return clusterClients.keySet();
    }
}
