package ru.yandex.infra.stage.yp;

import com.google.protobuf.ByteString;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytree.TAttribute;

public class Attributes {
    private Attributes() {}

    public static TAttribute stringAttribute(String key, String value) {
        return ysonAttribute(key, new YTreeBuilder().value(value).build());
    }

    public static TAttribute booleanAttribute(String key, boolean value) {
        return ysonAttribute(key, new YTreeBuilder().value(value).build());
    }

    private static TAttribute ysonAttribute(String key, YTreeNode value) {
        return binaryAttribute(key, value.toBinary());
    }

    public static TAttribute binaryAttribute(String key, byte[] value) {
        return TAttribute.newBuilder()
                .setKey(key)
                .setValue(ByteString.copyFrom(value))
                .build();
    }
}
