package ru.yandex.infra.stage.yp;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.util.StringUtils;

public class DeployObjectId {
    private final String stageId;
    private final String unitId;

    public DeployObjectId(String stageId, String unitId) {
        this.stageId = stageId;
        this.unitId = unitId;
    }

    public String getStageId() {
        return stageId;
    }

    public String getUnitId() {
        return unitId;
    }

    public String toStringId() {
        return stageId + StringUtils.ID_SEPARATOR + unitId;
    }

    public static Optional<DeployObjectId> tryParse(String id) {
        String[] parts = id.split(StringUtils.ID_SEPARATOR_REGEX, 2);
        if (parts.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new DeployObjectId(parts[0], parts[1]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployObjectId)) {
            return false;
        }
        DeployObjectId that = (DeployObjectId) o;
        return Objects.equals(stageId, that.stageId) &&
                Objects.equals(unitId, that.unitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(stageId, unitId);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("stageId", stageId)
                .add("unitId", unitId)
                .toString();
    }
}
