package ru.yandex.infra.stage.yp;

import java.util.Map;
import java.util.Optional;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.infra.controller.metrics.GaugeRegistry;
import ru.yandex.infra.controller.yp.LabelBasedRepository;
import ru.yandex.infra.controller.yp.YpObjectTransactionalRepository;
import ru.yandex.infra.stage.dto.ClusterAndType;
import ru.yandex.yp.YpRawObjectService;

public class LabelRepositoryFactory implements RepositoryFactory {

    private final Map<String, String> labelsMap;
    private final int pageSize;
    private final AsyncYpClientsMap ypClients;
    private final Optional<String> vcsPrefix;
    private final GaugeRegistry gaugeRegistry;


    public LabelRepositoryFactory(Map<String, String> labelsMap, int pageSize, AsyncYpClientsMap ypClients,
                                  Optional<String> vcsPrefix, GaugeRegistry gaugeRegistry) {
        this.labelsMap = labelsMap;
        this.pageSize = pageSize;
        this.ypClients = ypClients;
        this.vcsPrefix = vcsPrefix;
        this.gaugeRegistry = gaugeRegistry;
    }

    @Override
    public <Meta extends SchemaMeta, Spec extends Message, Status extends Message> YpObjectTransactionalRepository<Meta, Spec,
                Status> create(ClusterAndType clusterAndType) {
        YpRawObjectService ypClient = ypClients.getMultiOrClusterClient(clusterAndType.getCluster());
        return new LabelBasedRepository<>(clusterAndType.getType(), labelsMap, vcsPrefix,
                ypClient, EpochDecoratorRepositoryFactory.DESCRIPTORS.get(clusterAndType.getType()),
                pageSize, gaugeRegistry, clusterAndType.getCluster().orElse(LabelBasedRepository.ALL_CLUSTERS));
    }
}
