package ru.yandex.infra.stage.yp;

import java.util.concurrent.CompletableFuture;

public interface RelationController {

    //depending on setting: yp.relation_controller.add_missed_relations
    // Phase 1: check relation existence, create if missed (initial filling of relations for old objects)
    // Phase 2: check relation existence, exception if missed
    //flag should be removed after successful move to to Phase 2
    boolean containsRelation(String stageFqid, String childFqid);

    CompletableFuture<?> addRelation(String stageFqid, String childFqid);

    CompletableFuture<?> removeRelation(String stageFqid, String childFqid);

    RelationController EMPTY = new DummyRelationController();

    class DummyRelationController implements RelationController {
        @Override
        public CompletableFuture<?> addRelation(String stageFqid, String childFqid) {
            return CompletableFuture.completedFuture(0);
        }

        @Override
        public CompletableFuture<?> removeRelation(String stageFqid, String childFqid) {
            return CompletableFuture.completedFuture(0);
        }

        @Override
        public boolean containsRelation(String stageFqid, String childFqid) {
            return true;
        }
    }
}
